

<?php $__env->startSection('title', 'Forum Categories'); ?>

<?php $__env->startSection('content'); ?>
<div class="users-management">
    <div class="users-header">
        <h2>Forum Categories</h2>
        <div class="users-actions">
            <a href="<?php echo e(route('admin.forum.categories.create')); ?>" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Category
            </a>
        </div>
    </div>
    
    <div class="dashboard-card dashboard-card-full">
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Order</th>
                            <th>Name</th>
                            <th>Slug</th>
                            <th>Boards</th>
                            <th>Access</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($category->order); ?></td>
                            <td>
                                <?php echo e($category->name); ?>

                                <?php if(!$category->is_public): ?>
                                    <span class="forum-access-badge forum-access-badge--restricted">
                                        RESTRICTED
                                    </span>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($category->slug); ?></td>
                            <td><?php echo e($category->boards->count()); ?></td>
                            <td>
                                <?php if($category->is_public): ?>
                                    <span class="user-role role-user">Public</span>
                                <?php else: ?>
                                    <div class="forum-access-info">
                                        <?php if($category->required_roles): ?>
                                            <div class="forum-access-info__item">
                                                <strong>Roles:</strong> <?php echo e(implode(', ', $category->required_roles)); ?>

                                            </div>
                                        <?php endif; ?>
                                        <?php if($category->required_permissions): ?>
                                            <div class="forum-access-info__item">
                                                <strong>Perms:</strong> <?php echo e(implode(', ', $category->required_permissions)); ?>

                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="user-role <?php echo e($category->is_active ? 'role-moderator' : 'role-user'); ?>">
                                    <?php echo e($category->is_active ? 'Active' : 'Inactive'); ?>

                                </span>
                            </td>
                            <td class="user-actions">
                                <a href="<?php echo e(route('admin.forum.categories.edit', $category)); ?>" class="btn-icon" title="Edit Category">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="<?php echo e(route('admin.forum.categories.destroy', $category)); ?>" method="POST" class="d-inline">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="btn-icon btn-danger" title="Delete Category" onclick="return confirm('Are you sure you want to delete this category? This will also delete all boards and threads within it.')">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center">No categories found.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            
            <div class="forum-access-legend">
                <h6 class="forum-access-legend__title">
                    <i class="fas fa-info-circle"></i> Access Control Legend
                </h6>
                <div class="forum-access-legend__content">
                    <div class="forum-access-legend__item">
                        <strong>Public:</strong> Accessible by all users (including guests)
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Roles:</strong> User must have at least ONE of the listed roles
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Perms:</strong> User must have ALL of the listed permissions
                    </div>
                    <div class="forum-access-legend__item">
                        <strong>Restricted categories</strong> are marked with a red badge
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/forum/categories/index.blade.php ENDPATH**/ ?>